import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.shipperPackagingCfgId) {
    newObjValue = {...newObjValue, M_ShipperPackagingCfg_ID: {
      id: body.shipperPackagingCfgId,
      tableName: 'M_ShipperPackagingCfg'
    }}
  }

  if(body.shipperId) {
    const res: any = await fetchHelper(event, 'models/m_shipperpackaging', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      name: body.name,
      weight: body.weight,
      isDefault: body.isDefault,
      M_Shipper_ID: {
        id: body.shipperId,
        tableName: 'M_Shipper'
      },
      ...newObjValue,
      tableName: 'm_shipperpackaging'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})